<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Applicant extends Eloquent {

	protected $table = 'applicants';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function person()
	{
		return $this->hasOne('Person', 'person_id');
	}

	public function drinving_license()
	{
		return $this->hasOne('Title', 'param_id');
	}

	public function job()
	{
		return $this->hasOne('Job', 'job_id');
	}

	public function statute()
	{
		return $this->hasOne('Statute', 'statute_id');
	}

}