<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTitlesTable extends Migration {

	public function up()
	{
		Schema::create('titles', function(Blueprint $table) {
			$table->increments('id');
			$table->string('label', 255)->nullable()->index()->default('NULL');
			$table->enum('slug', array('permis', 'libelle_diplome'));
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('titles');
	}
}