<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNh7VenueTable extends Migration {

	public function up()
	{
		Schema::create('nh7_venue', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('event_id')->unsigned();
			$table->string('name');
			$table->boolean('is_active')->default(1);
			$table->text('address');
			$table->string('city');
			$table->integer('city_id')->unsigned();
			$table->string('pin_code')->nullable();
			$table->string('state')->nullable();
			$table->string('country')->nullable();
			$table->string('latitude')->nullable();
			$table->string('longitude')->nullable();
			$table->text('map_link')->nullable();
			$table->text('static_map_link')->nullable();
			$table->string('owner');
			$table->string('last_updated_by');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('nh7_venue');
	}
}