<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNh7FestivalSponsorTable extends Migration {

	public function up()
	{
		Schema::create('nh7_festival_sponsor', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('festival_id')->unsigned();
			$table->string('avatar')->nullable();
			$table->boolean('is_active')->default(1);
			$table->string('sponsored_by');
			$table->string('title')->nullable();
			$table->integer('sequence_no')->nullable();
			$table->string('owner');
			$table->string('last_updated_by');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('nh7_festival_sponsor');
	}
}