<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNh7VenueFacilityTable extends Migration {

	public function up()
	{
		Schema::create('nh7_venue_facility', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('venue_id')->unsigned();
			$table->string('avatar')->nullable();
			$table->string('name');
			$table->text('description')->nullable();
			$table->integer('sequence_no')->nullable();
			$table->boolean('is_active')->default(1);
			$table->string('owner');
			$table->string('last_updated_by');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('nh7_venue_facility');
	}
}