<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNh7FestivalArtistTable extends Migration {

	public function up()
	{
		Schema::create('nh7_festival_artist', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('festival_id')->unsigned();
			$table->integer('artist_id')->unsigned();
			$table->boolean('is_active')->default(1);
			$table->integer('sequence_no')->nullable();
			$table->date('onstage_date')->nullable();
			$table->time('onstage_time')->nullable();
			$table->string('owner');
			$table->string('last_updated_by');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('nh7_festival_artist');
	}
}