<?php

namespace Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Chance extends Model 
{

    protected $table = 'chances';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function chanceInstallments()
    {
        return $this->hasMany('ChanceInstallment');
    }

    public function risk()
    {
        return $this->belongsTo('Risk');
    }

    public function category()
    {
        return $this->belongsTo('Category');
    }

    public function investorGroups()
    {
        return $this->hasMany('ChanceInvestorGroup');
    }

    public function investments()
    {
        return $this->hasMany('Investment');
    }

    public function instruments()
    {
        return $this->hasMany('Instrument');
    }

    public function documents()
    {
        return $this->hasMany('ChanceDocument');
    }

}