<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvestorGroupsTable extends Migration {

	public function up()
	{
		Schema::create('investor_groups', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name_ar');
			$table->string('name_en');
			$table->timestamps();
			$table->softDeletes();
			$table->decimal('max_investment_yearly', 20,2);
			$table->tinyInteger('default')->default('0');
			$table->tinyInteger('enable_max_investment')->default('0');
			$table->decimal('chance_min_investment', 20,2);
			$table->decimal('chance_max_investment', 20,2);
		});
	}

	public function down()
	{
		Schema::drop('investor_groups');
	}
}