<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAppliedEmployeesTable extends Migration {

	public function up()
	{
		Schema::create('applied_employees', function(Blueprint $table) {
			$table->increments('id');
			$table->string('image')->nullable();
			$table->integer('cv_id');
			$table->integer('interview_id')->unsigned();
			$table->string('identity_source');
			$table->date('identity_date');
			$table->integer('nationality_id');
			$table->enum('gender', array(''male'', ''female''));
			$table->date('date_of_birth');
			$table->enum('marital_status', array(''single'', ''married'', ''married_and_dependent'', ''separated'', ''widowed''));
			$table->string('email', 60);
			$table->string('city', 35);
			$table->string('region', 35);
			$table->timestamps();
			$table->date('deactivated_at')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('applied_employees');
	}
}