<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInterviewsTable extends Migration {

	public function up()
	{
		Schema::create('interviews', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('cv_id')->unsigned();
			$table->date('date');
			$table->time('from_time');
			$table->time('to_time');
			$table->integer('status')->default('0');
			$table->string('audio')->nullable();
			$table->string('location');
			$table->datetime('attend_date')->nullable();
			$table->date('deactivated_at')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('interviews');
	}
}