<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('cvs', function(Blueprint $table) {
			$table->foreign('job_id')->references('id')->on('cvs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('interviews', function(Blueprint $table) {
			$table->foreign('cv_id')->references('id')->on('cvs')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('reception_employments', function(Blueprint $table) {
			$table->foreign('examination_cv_result_id')->references('id')->on('cvs')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('applied_employees', function(Blueprint $table) {
			$table->foreign('interview_id')->references('id')->on('interviews')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('qualifications', function(Blueprint $table) {
			$table->foreign('applied_employee_id')->references('id')->on('applied_employees')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('exprences', function(Blueprint $table) {
			$table->foreign('applied_employee_id')->references('id')->on('applied_employees')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('answar_applied_employee_question', function(Blueprint $table) {
			$table->foreign('applied_employee_id')->references('id')->on('applied_employees')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('answar_applied_employee_question', function(Blueprint $table) {
			$table->foreign('apply_answer_id')->references('id')->on('apply_answers')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('answar_applied_employee_question', function(Blueprint $table) {
			$table->foreign('apply_question_id')->references('id')->on('apply_questions')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('cvs', function(Blueprint $table) {
			$table->dropForeign('cvs_job_id_foreign');
		});
		Schema::table('interviews', function(Blueprint $table) {
			$table->dropForeign('interviews_cv_id_foreign');
		});
		Schema::table('reception_employments', function(Blueprint $table) {
			$table->dropForeign('reception_employments_examination_cv_result_id_foreign');
		});
		Schema::table('applied_employees', function(Blueprint $table) {
			$table->dropForeign('applied_employees_interview_id_foreign');
		});
		Schema::table('qualifications', function(Blueprint $table) {
			$table->dropForeign('qualifications_applied_employee_id_foreign');
		});
		Schema::table('exprences', function(Blueprint $table) {
			$table->dropForeign('exprences_applied_employee_id_foreign');
		});
		Schema::table('answar_applied_employee_question', function(Blueprint $table) {
			$table->dropForeign('answar_applied_employee_question_applied_employee_id_foreign');
		});
		Schema::table('answar_applied_employee_question', function(Blueprint $table) {
			$table->dropForeign('answar_applied_employee_question_apply_answer_id_foreign');
		});
		Schema::table('answar_applied_employee_question', function(Blueprint $table) {
			$table->dropForeign('answar_applied_employee_question_apply_question_id_foreign');
		});
	}
}