<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('orderdetails', function(Blueprint $table) {
			$table->foreign('order_id')->references('order_id')->on('orderdetails')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('designs', function(Blueprint $table) {
			$table->foreign('user_id')->references('user_id')->on('designs')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('designdetailimages', function(Blueprint $table) {
			$table->foreign('designdetail_id')->references('designdetail_id')->on('designdetailimages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('designdetails', function(Blueprint $table) {
			$table->foreign('design_id')->references('design_id')->on('designdetails')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('designdetails', function(Blueprint $table) {
			$table->foreign('side_id')->references('side_id')->on('designdetails')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('designdetails', function(Blueprint $table) {
			$table->foreign('type_id')->references('type_id')->on('designdetails')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('designmocks', function(Blueprint $table) {
			$table->foreign('design_id')->references('design_id')->on('designmocks')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('designmocks', function(Blueprint $table) {
			$table->foreign('side_id')->references('side_id')->on('designmocks')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('orderdetails', function(Blueprint $table) {
			$table->dropForeign('orderdetails_order_id_foreign');
		});
		Schema::table('designs', function(Blueprint $table) {
			$table->dropForeign('designs_user_id_foreign');
		});
		Schema::table('designdetailimages', function(Blueprint $table) {
			$table->dropForeign('designdetailimages_designdetail_id_foreign');
		});
		Schema::table('designdetails', function(Blueprint $table) {
			$table->dropForeign('designdetails_design_id_foreign');
		});
		Schema::table('designdetails', function(Blueprint $table) {
			$table->dropForeign('designdetails_side_id_foreign');
		});
		Schema::table('designdetails', function(Blueprint $table) {
			$table->dropForeign('designdetails_type_id_foreign');
		});
		Schema::table('designmocks', function(Blueprint $table) {
			$table->dropForeign('designmocks_design_id_foreign');
		});
		Schema::table('designmocks', function(Blueprint $table) {
			$table->dropForeign('designmocks_side_id_foreign');
		});
	}
}