<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBlockTable extends Migration {

	public function up()
	{
		Schema::create('block', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name')->unique();
			$table->text('structure');
			$table->text('function');
			$table->string('owner')->unique();
			$table->string('category');
			$table->string('description');
			$table->text('xml');
		});
	}

	public function down()
	{
		Schema::drop('block');
	}
}