<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class JadwalLiquid extends Model 
{

    protected $table = 'jadwal_liquid';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function jadwalLiquidUnit()
    {
        return $this->hasMany('App\JadwalLiquidUnit', 'jadwal_liquid_id', 'id');
    }

    public function fotoLiquid()
    {
        return $this->hasMany('App\FotoLiquid', 'jadwal_liquid_id', 'id');
    }

    public function penilaianAtasan()
    {
        return $this->hasMany('App\PenilaianAtasan', 'jadwal_liquid_id', 'id');
    }

    public function feedbackBawahan()
    {
        return $this->hasMany('App\FeedbackBawahan', 'jadwal_liquid_id', 'id');
    }

    public function jadwalLiquidJabatan()
    {
        return $this->hasMany('App\JadwalLiquidJabatan', 'jadwal_liquid_id', 'id');
    }

    public function feedback()
    {
        return $this->hasMany('App\Feedback', 'jadwal_liquid_id', 'id');
    }

}