<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class ResolusiAtasan extends Model 
{

    protected $table = 'resolusi_atasan';
    public $timestamps = true;

    public function pengukuranResolusi()
    {
        return $this->hasMany('App\PengukuranResolusi', 'resolusi_atasan_id', 'id');
    }

    public function aspek()
    {
        return $this->belongsTo('App\Aspek', 'aspek_id', 'id');
    }

    public function perilaku()
    {
        return $this->belongsTo('App\PerilakuLiquid', 'perilaku_id', 'id');
    }

    public function penilaianAtasan()
    {
        return $this->belongsTo('App\PenilaianAtasan', 'penilaian_atasan_id', 'id');
    }

}