<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMclientsTable extends Migration {

	public function up()
	{
		Schema::create('mclients', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('phone');
			$table->string('address_file')->unique();
			$table->string('password');
			$table->string('email');
			$table->integer('nationality_id')->unsigned();
			$table->string('origin')->nullable();
			$table->string('tribe')->nullable();
			$table->string('other')->nullable();
			$table->integer('city_id')->unsigned();
			$table->integer('residence_id')->unsigned();
			$table->enum('social_status', array('c', 'd', 'b', 'a'))->nullable();
			$table->integer('children_count')->unsigned()->nullable();
			$table->integer('age')->unsigned()->nullable();
			$table->enum('educational_level', array('a', 'b'))->nullable();
			$table->enum('work', array(''))->nullable();
			$table->enum('money_level', array('c', 'd', 'b', 'a'))->nullable();
			$table->enum('health_status', array(''));
			$table->enum('beauty', array('c', 'd', 'b', 'a'));
			$table->enum('religion_level', array('c', 'd', 'b', 'a'));
			$table->enum('skin_color', array(''));
			$table->integer('weight');
			$table->integer('height');
			$table->longText('detailed')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('mclients');
	}
}