<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAreaPostOfficesTable extends Migration {

	public function up()
	{
		Schema::create('area_post_offices', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 100);
			$table->string('slug', 100);
			$table->string('bn_name', 100)->nullable();
			$table->bigInteger('division_id')->unsigned();
			$table->bigInteger('district_id')->unsigned();
			$table->bigInteger('upazila_thana_id')->unsigned();
			$table->integer('code');
		});
	}

	public function down()
	{
		Schema::drop('area_post_offices');
	}
}