<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAreaWardsTable extends Migration {

	public function up()
	{
		Schema::create('area_wards', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 100);
			$table->string('slug', 100);
			$table->string('bn_name', 100)->nullable();
			$table->bigInteger('division_id')->unsigned();
			$table->bigInteger('district_id')->unsigned();
			$table->bigInteger('upazila_thana_id')->unsigned();
			$table->bigInteger('union_id')->unsigned()->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('area_wards');
	}
}