<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAreaUpazilaThanasTable extends Migration {

	public function up()
	{
		Schema::create('area_upazila_thanas', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('name', 100);
			$table->string('slug', 100);
			$table->string('bn_name', 100)->nullable();
			$table->enum('type', array('upazila', 'thana'));
			$table->bigInteger('division_id')->unsigned();
			$table->bigInteger('district_id')->unsigned();
			$table->integer('sl');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('area_upazila_thanas');
	}
}