<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('sous_categories', function(Blueprint $table) {
			$table->foreign('categories_id')->references('id')->on('sous_categories')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('articles', function(Blueprint $table) {
			$table->foreign('sous_categories_id')->references('id')->on('articles')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('commendes', function(Blueprint $table) {
			$table->foreign('clients_id')->references('id')->on('commendes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('clients', function(Blueprint $table) {
			$table->foreign('villes_id')->references('id')->on('clients')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('avoirs', function(Blueprint $table) {
			$table->foreign('commendes_id')->references('id')->on('avoirs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('relation', function(Blueprint $table) {
			$table->foreign('articles_id')->references('id')->on('articles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('relation', function(Blueprint $table) {
			$table->foreign('commendes_id')->references('id')->on('commendes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('sous_categories', function(Blueprint $table) {
			$table->dropForeign('sous_categories_categories_id_foreign');
		});
		Schema::table('articles', function(Blueprint $table) {
			$table->dropForeign('articles_sous_categories_id_foreign');
		});
		Schema::table('commendes', function(Blueprint $table) {
			$table->dropForeign('commendes_clients_id_foreign');
		});
		Schema::table('clients', function(Blueprint $table) {
			$table->dropForeign('clients_villes_id_foreign');
		});
		Schema::table('avoirs', function(Blueprint $table) {
			$table->dropForeign('avoirs_commendes_id_foreign');
		});
		Schema::table('relation', function(Blueprint $table) {
			$table->dropForeign('relation_articles_id_foreign');
		});
		Schema::table('relation', function(Blueprint $table) {
			$table->dropForeign('relation_commendes_id_foreign');
		});
	}
}