<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSalesReturnOrderItemsTable extends Migration {

	public function up()
	{
		Schema::create('sales_return_order_items', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('sales_return_orders_id')->unsigned();
			$table->timestamp('returned_at');
			$table->integer('warehouses_id')->unsigned();
			$table->integer('product_versions_id')->unsigned();
			$table->integer('uoms_id')->unsigned();
			$table->double('quantity');
			$table->double('price');
		});
	}

	public function down()
	{
		Schema::drop('sales_return_order_items');
	}
}