<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFinancialStoragesTable extends Migration {

	public function up()
	{
		Schema::create('financial_storages', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('slug', 64)->unique();
			$table->string('name', 32);
			$table->text('notes');
		});
	}

	public function down()
	{
		Schema::drop('financial_storages');
	}
}