<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateIncomeItemsTable extends Migration {

	public function up()
	{
		Schema::create('income_items', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->timestamp('received_at');
			$table->enum('ref', array('sales', 'tags'));
			$table->integer('ref_id');
			$table->integer('financial_storages_id')->unsigned();
			$table->double('amount');
			$table->text('notes');
		});
	}

	public function down()
	{
		Schema::drop('income_items');
	}
}