<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('slug', 64);
			$table->string('name', 32)->unique();
			$table->text('descriptions');
			$table->double('sell_price');
			$table->double('purchase_price');
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}