<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductMovementOrdersTable extends Migration {

	public function up()
	{
		Schema::create('product_movement_orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('code')->unique();
			$table->integer('warehouses_id')->unsigned();
			$table->timestamp('issued');
			$table->enum('clause', array('sales', 'purchase', 'return', 'broken', 'opnamin', 'opnameout', 'consume', 'move'));
			$table->text('notes');
		});
	}

	public function down()
	{
		Schema::drop('product_movement_orders');
	}
}