<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSalesOrderItemsTable extends Migration {

	public function up()
	{
		Schema::create('sales_order_items', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('product_versions_id')->unsigned();
			$table->softDeletes();
			$table->integer('warehouses_id')->unsigned();
			$table->integer('sales_orders_id')->unsigned();
			$table->integer('uom_id')->unsigned();
			$table->double('quantity');
			$table->double('price');
		});
	}

	public function down()
	{
		Schema::drop('sales_order_items');
	}
}