<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('order_number', 191);
			$table->string('phone', 191);
			$table->string('location', 191);
			$table->enum('order_status', array(''pending'', ''ready'', ''complete'', ''canceled''));
			$table->integer('items_count')->nullable();
			$table->double('price')->nullable();
			$table->integer('restaurant_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}