<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->enum('type', array('as_requested', 'given_name', 'given_service'))->nullable();
			$table->string('client_name')->nullable();
			$table->string('client_mobile')->nullable();
			$table->string('civil_registry')->nullable();
			$table->string('city')->nullable();
			$table->string('area')->nullable();
			$table->string('family_count')->nullable();
			$table->string('social_status')->nullable();
			$table->string('client_email')->nullable();
			$table->string('client_residency_number')->nullable();
			$table->string('visa_number')->nullable();
			$table->integer('nationality_id')->unsigned();
			$table->enum('gender', array('male', 'female'))->nullable();
			$table->integer('job_title_id')->unsigned();
			$table->integer('cv_id')->unsigned();
			$table->string('passport_image')->nullable();
			$table->string('family_card')->nullable();
			$table->enum('follow_type', array('sms', 'email', 'both'))->nullable();
			$table->string('client_sign')->nullable();
			$table->string('code')->nullable();
			$table->integer('office_id')->unsigned();
			$table->enum('status', array('new', 'foreign_accept', 'paid', 'not_verified', 'polo', 'verified', 'in_shipping', 'in_progress', 'travel', 'delivered', 'cancel'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}