<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateComplaintsTable extends Migration {

	public function up()
	{
		Schema::create('complaints', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('order_id')->unsigned();
			$table->text('notes')->nullable();
			$table->string('code')->nullable();
			$table->enum('status', array('new', 'closed'))->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('complaints');
	}
}