<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Business extends Model 
{

    protected $table = 'businesses';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('business_name', 'email', 'phone_number', 'address_1', 'address_2', 'city', 'postal_code', 'owner_name', 'owner_email', 'owner_phone', 'poc_name', 'poc_email', 'poc_phone', 'website', 'status', 'country_id', 'state_id', 'subscription_id', 'user_id', 'request_message', 'merchant_customer_id', 'merchant_descriptor', 'data');
    protected $visible = array('business_name', 'email', 'phone_number', 'address_1', 'address_2', 'city', 'postal_code', 'owner_name', 'owner_email', 'owner_phone', 'poc_name', 'poc_email', 'poc_phone', 'website', 'status', 'country_id', 'state_id', 'subscription_id', 'user_id', 'request_message', 'merchant_customer_id', 'merchant_descriptor', 'data');

    public function country()
    {
        return $this->hasOne('Country');
    }

    public function state()
    {
        return $this->hasOne('State');
    }

    public function subscription()
    {
        return $this->hasOne('Subscription');
    }

    public function user()
    {
        return $this->belongsTo('Users');
    }

    public function influencers()
    {
        return $this->hasManyThrough('Influencer')->withPivot('business_influencer_pivot');
    }

}