<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePostsTable extends Migration {

	public function up()
	{
		Schema::create('posts', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('campaign_id');
			$table->integer('influencer_id')->unsigned();
			$table->string('status');
			$table->string('type', 64);
			$table->string('name', 256);
			$table->text('description');
			$table->datetime('scheduled_at')->nullable();
			$table->string('platform_provider')->nullable();
			$table->string('platform_provider_id', 255)->nullable();
			$table->timestamps();
			$table->text('post_link')->nullable();
			$table->json('data')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('posts');
	}
}