<?php

namespace App\Models;

class Service extends Eloquent {

	protected $table = 'services';
	public $timestamps = true;

	public function client()
	{
		return $this->belongsTo('App\Models\Client', 'client_id');
	}

	public function assigned()
	{
		return $this->belongsTo('App\Models\User', 'assigned_id');
	}

	public function createdBy()
	{
		return $this->hasOne('App\Models\User', 'id', 'created_id');
	}

	public function updatedBy()
	{
		return $this->hasOne('App\Models\User', 'id', 'updated_id');
	}

}