<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSmsTable extends Migration {

	public function up()
	{
		Schema::create('sms', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('from_id')->unsigned();
			$table->text('message');
			$table->date('created');
			$table->enum('status', array('pending', 'ok', 'fail'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('sms');
	}
}