<?php

namespace models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Facility extends Model 
{

    protected $table = 'facilits';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'owner_id', 'category_id');

    public function owner()
    {
        return $this->belongsTo('Owner', 'owner_id');
    }

    public function category()
    {
        return $this->belongsTo('Category', 'category_id');
    }

    public function town()
    {
        return $this->belongsTo('Town', 'town_id');
    }

    public function images()
    {
        return $this->morphMany('Images');
    }

}