<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('Medications', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Medications', function(Blueprint $table) {
			$table->foreign('caliber_id')->references('id')->on('doses')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Medications', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('medication_doses', function(Blueprint $table) {
			$table->foreign('medication_id')->references('id')->on('Shapes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('medication_doses', function(Blueprint $table) {
			$table->foreign('dose_id')->references('id')->on('doses')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('Medications', function(Blueprint $table) {
			$table->dropForeign('Medications_category_id_foreign');
		});
		Schema::table('Medications', function(Blueprint $table) {
			$table->dropForeign('Medications_caliber_id_foreign');
		});
		Schema::table('Medications', function(Blueprint $table) {
			$table->dropForeign('Medications_company_id_foreign');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->dropForeign('categories_parent_id_foreign');
		});
		Schema::table('medication_doses', function(Blueprint $table) {
			$table->dropForeign('medication_doses_medication_id_foreign');
		});
		Schema::table('medication_doses', function(Blueprint $table) {
			$table->dropForeign('medication_doses_dose_id_foreign');
		});
	}
}