<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLessonsTable extends Migration {

	public function up()
	{
		Schema::create('lessons', function(Blueprint $table) {
			$table->increments('id');
			$table->softDeletes();
			$table->integer('total_seats');
			$table->datetime('start_date');
			$table->datetime('end_date');
			$table->integer('tutor_id')->unsigned();
			$table->string('lesson_type');
			$table->longText('lesson_details');
			$table->integer('duration')->default('0');
			$table->string('slug', 255);
			$table->string('meta_title', 255);
			$table->string('meta_description', 255);
			$table->string('meta_keywords', 255);
			$table->string('cover_image', 255);
			$table->integer('price');
			$table->datetime('access_period');
			$table->tinyInteger('status');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('lessons');
	}
}