<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('datos_tsg', function(Blueprint $table) {
			$table->foreign('id_persona')->references('id')->on('Persona')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('datos_tish', function(Blueprint $table) {
			$table->foreign('id_persona')->references('id')->on('Persona')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('datos_tsg', function(Blueprint $table) {
			$table->dropForeign('datos_tsg_id_persona_foreign');
		});
		Schema::table('datos_tish', function(Blueprint $table) {
			$table->dropForeign('datos_tish_id_persona_foreign');
		});
	}
}