<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Order extends Eloquent {

	protected $table = 'orders';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function shipping_info()
	{
		return $this->hasOne('\ShippingInformation');
	}

	public function order_detail()
	{
		return $this->hasOne('OrderDetails');
	}

}