<?php

namespace App\Model;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'user';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function cart()
	{
		return $this->hasMany('\Cart');
	}

	public function order()
	{
		return $this->hasMany('\Order');
	}

	public function shipping_info()
	{
		return $this->hasMany('\ShippingInformation');
	}

}