<?php

namespace App\Models;

class Category extends Eloquent {

	protected $table = 'categories';
	public $timestamps = true;
	protected $fillable = array('name', 'slug', 'image', 'parent_id');

	public function parent()
	{
		return $this->belongsTo('App\Models\Category', 'parent_id');
	}

	public function posts()
	{
		return $this->hasMany('App\Models\Post');
	}

}