<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Pago extends Model 
{

    protected $table = 'pagos';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('precio_unitario', 'total_pagado');

    public function detallePago()
    {
        return $this->hasMany('App\PagoDetalle', 'pago_id');
    }

}