<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateComisionesTable extends Migration {

	public function up()
	{
		Schema::create('comisiones', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('distribuidor_id')->unsigned()->nullable();
			$table->integer('tipo_activacion_id')->unsigned()->nullable();
			$table->integer('semana_id')->unsigned()->nullable();
			$table->integer('cantidad')->unsigned()->default('1');
			$table->float('precio_unitario');
			$table->float('total_activacion');
			$table->integer('activos_nivel1');
			$table->float('comision_por_nivel1');
			$table->float('comision_nivel1');
			$table->integer('activos_nivel2');
			$table->float('comision_por_nivel2');
			$table->float('comision_nivel2');
			$table->float('total_comision');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('comisiones');
	}
}