<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Activacion extends Eloquent {

	protected $table = 'activaciones';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('fechahora_pago', 'cantidad_comprada', 'total_pagado', 'saldo', 'estatus_activacion');

	public function distribuidor()
	{
		return $this->belongsTo('App\Distribuidor', 'distribuidor_id');
	}

}