<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class PagoDetalle extends Eloquent {

	protected $table = 'pagos_detalle';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('monto');

	public function tipoPago()
	{
		return $this->hasOne('App\TipoPago');
	}

	public function medioDePago()
	{
		return $this->hasOne('App\MediosDePago', 'medio_de_pago_id');
	}

}