<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Activacion extends Model 
{

    protected $table = 'activaciones';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('fechahora_pago', 'cantidad_comprada', 'total_pagado', 'saldo', 'estatus_activacion');

    public function distribuidor()
    {
        return $this->belongsTo('App\Distribuidor', 'distribuidor_id');
    }

}