<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Comision extends Model 
{

    protected $table = 'comisiones';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('distribuidor_id', 'tipo_activacion_id', 'semana_id', 'cantidad', 'precio_unitario', 'total_activacion', 'activos_nivel1', 'comision_por_nivel1', 'comision_nivel1', 'activos_nivel2', 'comision_por_nivel2', 'total_comision');

    public function distribuidor()
    {
        return $this->belongsTo('App\Distribuidor', 'distribuidor_id');
    }

    public function detalleComision()
    {
        return $this->hasMany('App\ComisionDetalle', 'comision_id');
    }

    public function tipoActivacion()
    {
        return $this->hasOne('App\TipoActivacion', 'tipoActivacion_id');
    }

    public function semana()
    {
        return $this->hasOne('App\Semana', 'semana_id');
    }

}