<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('chat_group_members', function(Blueprint $table) {
			$table->foreign('group_id')->references('id')->on('chat_groups')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('chat_group_members', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('chat_messages', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('chat_messages')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('chat_messages', function(Blueprint $table) {
			$table->foreign('receiver_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('chat_messages', function(Blueprint $table) {
			$table->foreign('sender_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('chat_group_messages', function(Blueprint $table) {
			$table->foreign('chat_group_id')->references('id')->on('chat_groups')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('chat_group_messages', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('chat_group_messages')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('chat_group_messages', function(Blueprint $table) {
			$table->foreign('sender_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('chat_group_members', function(Blueprint $table) {
			$table->dropForeign('chat_group_members_group_id_foreign');
		});
		Schema::table('chat_group_members', function(Blueprint $table) {
			$table->dropForeign('chat_group_members_user_id_foreign');
		});
		Schema::table('chat_messages', function(Blueprint $table) {
			$table->dropForeign('chat_messages_parent_id_foreign');
		});
		Schema::table('chat_messages', function(Blueprint $table) {
			$table->dropForeign('chat_messages_receiver_id_foreign');
		});
		Schema::table('chat_messages', function(Blueprint $table) {
			$table->dropForeign('chat_messages_sender_id_foreign');
		});
		Schema::table('chat_group_messages', function(Blueprint $table) {
			$table->dropForeign('chat_group_messages_chat_group_id_foreign');
		});
		Schema::table('chat_group_messages', function(Blueprint $table) {
			$table->dropForeign('chat_group_messages_parent_id_foreign');
		});
		Schema::table('chat_group_messages', function(Blueprint $table) {
			$table->dropForeign('chat_group_messages_sender_id_foreign');
		});
	}
}