<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAdminUsersTable extends Migration {

	public function up()
	{
		Schema::create('admin_users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 250);
			$table->string('email', 250);
			$table->string('password', 250);
			$table->string('image', 250)->nullable();
			$table->string('company_name', 150)->nullable();
			$table->enum('is_active', array('0', '1'));
			$table->string('remember_token', 250)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('admin_users');
	}
}