<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserDevicesTable extends Migration {

	public function up()
	{
		Schema::create('user_devices', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id');
			$table->string('country_code', 150);
			$table->string('mobile', 150);
			$table->enum('device_type', array('0', '1'));
			$table->string('device_token', 250);
			$table->enum('is_logout', array('0', '1'))->nullable();
			$table->datetime('login_time');
			$table->datetime('logout_time');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('user_devices');
	}
}