<?php

namespace TripHistory;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class TripHistory extends Eloquent {

	protected $table = 'trip_history';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('trip_id', 'driver_id', 'title', 'latitude', 'longitude', 'waiting_time');

	public function getTrip()
	{
		return $this->hasOne('Trip', 'trip_id');
	}

	public function getDriver()
	{
		return $this->hasOne('Driver', 'driver_id');
	}

}